unit Samcal;

interface

 {
    ShowMessage('Date from TAdrockCalendarEdit = '+DateToStr(AdrockCalendarEdit2.Date));
    ShowMessage('Date from TAdrockCalendarEdit2 = '+FormatDateTime('D/MM/YYYY', AdrockCalendarEdit2.Date));

   The function using DateToStr(xxx) will return the year as only yy which
   can loose precision if the string is then converted back to a datetime object.

   Example: TAdrockCalendarEdit.Date = EncodeDate(2050, 10, 10);  Date = 10/10/2050
            StrVar := DateToStr(TAdrockCalendarEdit.Date)

            StrVar now contains 10/10/50 - Look normal?

            Now convert the string back to a TDateTime;

            TDateTimeVar = StrToDateTo(StrVar);

            TDateTime will now be basically holding the date 10/10/1950

   Moral:   Use the FormatDateTime function instead of DateToStr

            StrVar := FormatDateTime('D/MM/YYYY', EncodeDate(2050,10,10))

            StrVar now contains 10/10/2050
 }


uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Adcalbtn, Buttons, DB, DBTables,
  Grids, DBGrids, DBCtrls, TabNotBk;

type
  EInvalidDate = class(Exception);          { Exception when an InValid Date is entered  }
  TForm1 = class(TForm)
    Panel1: TPanel;
    Label1: TLabel;
    Panel2: TPanel;
    Label2: TLabel;
    Label3: TLabel;
    Bevel1: TBevel;
    DataSource1: TDataSource;
    Table1: TTable;
    TabbedNotebook1: TTabbedNotebook;
    Panel5: TPanel;
    Label6: TLabel;
    Label8: TLabel;
    Bevel2: TBevel;
    AdrockCalendarEdit1: TAdrockCalendarEdit;
    DBNavigator1: TDBNavigator;
    DBGrid1: TDBGrid;
    AdrockCalendarEdit8: TAdrockCalendarEdit;
    Label17: TLabel;
    Label18: TLabel;
    Label20: TLabel;
    Label19: TLabel;
    Panel4: TPanel;
    GroupBox1: TGroupBox;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    AdrockCalendarEdit9: TAdrockCalendarEdit;
    AdrockCalendarEdit10: TAdrockCalendarEdit;
    AdrockCalendarEdit11: TAdrockCalendarEdit;
    AdrockCalendarEdit12: TAdrockCalendarEdit;
    Label13: TLabel;
    AdrockCalendarEdit13: TAdrockCalendarEdit;
    Label14: TLabel;
    AdrockCalendarEdit14: TAdrockCalendarEdit;
    Label15: TLabel;
    AdrockCalendarEdit15: TAdrockCalendarEdit;
    Label16: TLabel;
    AdrockCalendarEdit16: TAdrockCalendarEdit;
    SetCalendarFontButton: TBitBtn;
    AdrockCalendarEdit22: TAdrockCalendarEdit;
    FontDialog1: TFontDialog;
    Label26: TLabel;
    Label27: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    Label30: TLabel;
    Label31: TLabel;
    Label32: TLabel;
    Label21: TLabel;
    Label4: TLabel;
    Label7: TLabel;
    Label22: TLabel;
    Label5: TLabel;
    AdrockCalendarEdit17: TAdrockCalendarEdit;
    AdrockCalendarEdit18: TAdrockCalendarEdit;
    AdrockCalendarEdit19: TAdrockCalendarEdit;
    AdrockCalendarEdit20: TAdrockCalendarEdit;
    AdrockCalendarEdit21: TAdrockCalendarEdit;
    Radio2: TGroupBox;
    RadioButton7: TRadioButton;
    RadioButton8: TRadioButton;
    RadioButton9: TRadioButton;
    Radio1: TGroupBox;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    Radio3: TGroupBox;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    Radio4: TGroupBox;
    RadioButton3: TRadioButton;
    RadioButton4: TRadioButton;
    RadioButton5: TRadioButton;
    RadioButton6: TRadioButton;
    Label23: TLabel;
    AllowManualDateEntryCheckBox: TCheckBox;
    ShowButtonNeverRadioButton: TRadioButton;
    RadioButton11: TRadioButton;
    RadioButton12: TRadioButton;
    AdrockCalendarEdit2: TAdrockCalendarEdit;
    Memo1: TMemo;
    Panel3: TPanel;
    Label24: TLabel;
    Panel6: TPanel;
    Label25: TLabel;
    VersionLabel: TLabel;
    onDayChangeCheckBox: TCheckBox;
    onMonthChangeCheckBox: TCheckBox;
    onYearChangeCheckBox: TCheckBox;
    onResetToTodayCheckBox: TCheckBox;
    onCalendarOpenCheckBox: TCheckBox;
    onCalendarCloseCheckBox: TCheckBox;
    onCalendarPickDateCheckBox: TCheckBox;
    onButtonClickCheckBox: TCheckBox;
    onChangeCheckBox: TCheckBox;
    Label33: TLabel;
    KeyPress: TLabel;
    Label34: TLabel;
    KeyDown: TLabel;
    Label35: TLabel;
    KeyUp: TLabel;
    Label36: TLabel;
    ShiftState: TLabel;
    Bevel3: TBevel;
    Label37: TLabel;
    Label38: TLabel;
    Label39: TLabel;
    Label40: TLabel;
    Label41: TLabel;
    Label42: TLabel;
    CalendarCaptionFont: TBitBtn;
    Panel7: TPanel;
    Label43: TLabel;
    OnInvalidDateEventCheckBox: TCheckBox;
    OnRequiredDateEventCheckBox: TCheckBox;
    OnBadRangeEventCheckBox: TCheckBox;
    Table1LAST_NAME: TStringField;
    Table1FIRST_NAME: TStringField;
    Table1DATE_OPEN: TDateField;
    CalendarStatusFont: TBitBtn;
    procedure SetCalendarFontButtonClick(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure RadioButton1Click(Sender: TObject);
    procedure RadioButton2Click(Sender: TObject);
    procedure RadioButton3Click(Sender: TObject);
    procedure RadioButton4Click(Sender: TObject);
    procedure RadioButton5Click(Sender: TObject);
    procedure RadioButton6Click(Sender: TObject);
    procedure RadioButton7Click(Sender: TObject);
    procedure RadioButton8Click(Sender: TObject);
    procedure RadioButton9Click(Sender: TObject);
    procedure TabbedNotebook1Change(Sender: TObject; NewTab: Integer;
      var AllowChange: Boolean);
    procedure AllowManualDateEntryCheckBoxClick(Sender: TObject);
    procedure ShowButtonNeverRadioButtonClick(Sender: TObject);
    procedure RadioButton11Click(Sender: TObject);
    procedure RadioButton12Click(Sender: TObject);
    procedure AdrockCalendarEdit22DayChange(Sender: TObject);
    procedure AdrockCalendarEdit22MonthChange(Sender: TObject);
    procedure AdrockCalendarEdit22YearChange(Sender: TObject);
    procedure AdrockCalendarEdit22ResetToToday(Sender: TObject);
    procedure AdrockCalendarEdit22CalendarPickDate(Sender: TObject);
    procedure AdrockCalendarEdit22CalendarClose(Sender: TObject);
    procedure AdrockCalendarEdit22CalendarOpen(Sender: TObject);
    procedure AdrockCalendarEdit22Change(Sender: TObject);
    procedure AdrockCalendarEdit22ButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure CalendarCaptionFontClick(Sender: TObject);
    procedure OnRequiredDateEventCheckBoxClick(Sender: TObject);
    procedure OnInvalidDateEventCheckBoxClick(Sender: TObject);
    procedure AdrockCalendarEdit2RequiredDateEvent(Sender: TObject);
    procedure OnBadRangeEventCheckBoxClick(Sender: TObject);
    procedure AdrockCalendarEdit2InvalidDateEvent(Sender: TObject;
      CurrentDate: TDateTime; DateString, BadDateMessage: String);
    procedure AdrockCalendarEdit2BadRangeEvent(Sender: TObject;
      CurrentDate, MinDate, MaxDate: TDateTime; DefaultMessage: String;
      RangeError: TAdrockRangeErrors);
    procedure CalendarStatusFontClick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure AdrockCalendarEdit1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
    InUpdateFromRadioButton : Boolean;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.SetCalendarFontButtonClick(Sender: TObject);
begin
     FontDialog1.Font.Assign(AdrockCalendarEdit22.CalendarFont);
     FontDialog1.Execute;
     AdrockCalendarEdit22.CalendarFont.Assign(fontDialog1.Font);
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
     AdrockCalendarEdit22.ShowPrevNextMonth := not AdrockCalendarEdit22.ShowPrevNextMonth;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
     AdrockCalendarEdit22.ShowWeekNumbers := not AdrockCalendarEdit22.ShowWeekNumbers;
end;

procedure TForm1.RadioButton1Click(Sender: TObject);
begin
     AdrockCalendarEdit22.StartOfWeek := swSunday;
end;

procedure TForm1.RadioButton2Click(Sender: TObject);
begin
     AdrockCalendarEdit22.StartOfWeek := swMonday;
end;

procedure TForm1.RadioButton3Click(Sender: TObject);
begin
     AdrockCalendarEdit22.CalendarPosition := cpLeftTop;
end;

procedure TForm1.RadioButton4Click(Sender: TObject);
begin
    AdrockCalendarEdit22.CalendarPosition := cpRightTop;
end;

procedure TForm1.RadioButton5Click(Sender: TObject);
begin
    AdrockCalendarEdit22.CalendarPosition := cpLeftBottom;

end;

procedure TForm1.RadioButton6Click(Sender: TObject);
begin
    AdrockCalendarEdit22.CalendarPosition := cpRightBottom;
end;

procedure TForm1.RadioButton7Click(Sender: TObject);
begin
    AdrockCalendarEdit22.Alignment := taCenter;
end;

procedure TForm1.RadioButton8Click(Sender: TObject);
begin
    AdrockCalendarEdit22.Alignment := taLeftJustify;
end;

procedure TForm1.RadioButton9Click(Sender: TObject);
begin
    AdrockCalendarEdit22.Alignment := taRightJustify;
end;

procedure TForm1.TabbedNotebook1Change(Sender: TObject; NewTab: Integer;
  var AllowChange: Boolean);
begin
  AllowChange := TRUE;
  if (NewTab = 2) then
   begin
     try;
       Table1.Open;
     except;
       MessageDlg('Sorry, unable to open the Database Table', mtError, [mbOK], 0);
       AllowChange := FALSE;
     end;
   end
{  else
    Table1.Open;}
end;

procedure TForm1.AllowManualDateEntryCheckBoxClick(Sender: TObject);
begin
  AdrockCalendarEdit22.AllowManualDateEntry := not AdrockCalendarEdit22.AllowManualDateEntry;
  if (InUpdateFromRadioButton = FALSE) then
    if (AdrockCalendarEdit22.AllowManualDateEntry = FALSE) then
       ShowButtonNeverRadioButton.Checked := TRUE;
end;

procedure TForm1.ShowButtonNeverRadioButtonClick(Sender: TObject);
begin
    AdrockCalendarEdit22.ShowButton := sbNever;
end;

procedure TForm1.RadioButton11Click(Sender: TObject);
begin
    AdrockCalendarEdit22.ShowButton := sbFFocused;
    InUpdateFromRadioButton := TRUE;
    AllowManualDateEntryCheckBox.Checked := TRUE;
    InUpdateFromRadioButton := FALSE;
end;

procedure TForm1.RadioButton12Click(Sender: TObject);
begin
    AdrockCalendarEdit22.ShowButton := sbAlways;
    InUpdateFromRadioButton := TRUE;
    AllowManualDateEntryCheckBox.Checked := TRUE;
    InUpdateFromRadioButton := FALSE;
end;

procedure TForm1.AdrockCalendarEdit22DayChange(Sender: TObject);
begin
  if (OnDayChangeCheckBox.Checked = TRUE) then
   begin
     Memo1.Lines.Insert(0, 'onDayChange '+AdrockCalendarEdit2.AsString);
   end;
end;

procedure TForm1.AdrockCalendarEdit22MonthChange(Sender: TObject);
begin
  if (OnMonthChangeCheckBox.Checked = TRUE) then
     Memo1.Lines.Insert(0, 'onMonthChange '+AdrockCalendarEdit2.AsString);
end;

procedure TForm1.AdrockCalendarEdit22YearChange(Sender: TObject);
begin
  if (OnYearChangeCheckBox.Checked = TRUE) then
     Memo1.Lines.Insert(0, 'onYearChange '+AdrockCalendarEdit2.AsString);
end;

procedure TForm1.AdrockCalendarEdit22ResetToToday(Sender: TObject);
begin
  if (OnResetToTodayCheckBox.Checked = TRUE) then
     Memo1.Lines.Insert(0, 'onResetToToday '+AdrockCalendarEdit2.AsString);
end;

procedure TForm1.AdrockCalendarEdit22CalendarPickDate(Sender: TObject);
begin
  if (OnCalendarPickDateCheckBox.Checked = TRUE) then
     Memo1.Lines.Insert(0, 'onCalendarPickDate '+AdrockCalendarEdit2.AsString);
end;

procedure TForm1.AdrockCalendarEdit22CalendarClose(Sender: TObject);
begin
  if (OnCalendarCloseCheckBox.Checked = TRUE) then
     Memo1.Lines.Insert(0, 'onCalendarClose');
end;

procedure TForm1.AdrockCalendarEdit22CalendarOpen(Sender: TObject);
begin
  if (OnCalendarOpenCheckBox.Checked = TRUE) then
     Memo1.Lines.Insert(0, 'onCalendarOpen');
end;

procedure TForm1.AdrockCalendarEdit22Change(Sender: TObject);
begin
  if (OnChangeCheckBox.Checked = TRUE) then
    Memo1.Lines.Insert(0, 'onChange');

end;

procedure TForm1.AdrockCalendarEdit22ButtonClick(Sender: TObject);
begin
  if (OnButtonClickCheckBox.Checked = TRUE) then
     Memo1.Lines.Insert(0, 'onButtonClick');
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
     Caption := 'Sample program for TAdrockCalendarEdit Version '+AdrockCalendarEdit22.Version;
     VersionLabel.Caption := 'TAdrockCalendarEdit Version '+AdrockCalendarEdit22.Version;
     TabbedNotebook1.PageIndex :=0;
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
     KeyDown.Caption := IntToStr(Key);
     if (Shift = [SSAlt]) then
       ShiftState.Caption := '[ssAlt]'
     Else if (Shift = [SSAlt, SSCtrl]) then
       ShiftState.Caption := '[ssAlt, ssCtrl]'
     else if (Shift = [SSAlt, ssShift]) then
       ShiftState.Caption := '[ssAlt, ssShift]'

     else if (Shift = [SSCtrl]) then
       ShiftState.Caption := '[ssCtrl]'
     else if (Shift = [SSCtrl, ssSHIFT]) then
       ShiftState.Caption := '[ssCtrl, ssShift]'

     else if (Shift = [SSShift]) then
       ShiftState.Caption := '[ssShift]'
     else
       ShiftState.Caption := '[]';
     KeyUp.Caption := '';
end;



procedure TForm1.FormKeyPress(Sender: TObject; var Key: Char);
begin
     KeyPress.Caption := IntToStr(Ord(Key));
end;

procedure TForm1.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
   KeyUp.Caption := IntToStr(Key);
   KeyDown.Caption := '';
   ShiftState.Caption := '[]';
end;

procedure TForm1.CalendarCaptionFontClick(Sender: TObject);
begin
     FontDialog1.Font.Assign(AdrockCalendarEdit22.CalendarCaptionFont);
     FontDialog1.Execute;
     AdrockCalendarEdit22.CalendarCaptionFont.Assign(fontDialog1.Font);
end;

procedure TForm1.OnRequiredDateEventCheckBoxClick(Sender: TObject);
begin
  AdrockCalendarEdit2.Required := OnInvalidDateEventCheckBox.Checked;
  if (OnInvalidDateEventCheckBox.Checked = TRUE) then
      AdrockCalendarEdit2.OnRequiredDateEvent := AdrockCalendarEdit2RequiredDateEvent
  else
      AdrockCalendarEdit2.OnRequiredDateEvent := Nil;
end;

procedure TForm1.OnInvalidDateEventCheckBoxClick(Sender: TObject);
begin
  if (OnInvalidDateEventCheckBox.Checked = TRUE) then
      AdrockCalendarEdit2.OnInvalidDatEEvent := AdrockCalendarEdit2InvalidDateEvent
  else
      AdrockCalendarEdit2.OnInvalidDatEEvent := Nil;
end;

procedure TForm1.AdrockCalendarEdit2RequiredDateEvent(Sender: TObject);
begin
     ShowMessage('New Handler: This field is required');
end;

procedure TForm1.OnBadRangeEventCheckBoxClick(Sender: TObject);
begin
  if (OnInvalidDateEventCheckBox.Checked = TRUE) then
    begin
      AdrockCalendarEdit2.OnBadRangeEvent := AdrockCalendarEdit2BadRangeEvent;
    end
  else
    begin
      AdrockCalendarEdit2.OnBadRangeEvent := Nil;
    end;
end;

procedure TForm1.AdrockCalendarEdit2InvalidDateEvent(Sender: TObject;
  CurrentDate: TDateTime; DateString, BadDateMessage: String);
begin
   {Raise EInValidDate.Create('This is bad news');}
   ShowMessage('New Handler : '+BadDateMessage);
end;

procedure TForm1.AdrockCalendarEdit2BadRangeEvent(Sender: TObject;
  CurrentDate, MinDate, MaxDate: TDateTime; DefaultMessage: String;
  RangeError: TAdrockRangeErrors);
begin
     ShowMessage('Custom Error Handler : Bad Range Error :'+#13+
                      'Date = '+DateToStr(CurrentDate)+#13+
                      'MinDate = '+DateToStr(MinDate)+#13+
                      'MaxDate = '+DateToStr(MaxDate)+#13+
                      'DefaultMessage = '+DefaultMessage);

end;

procedure TForm1.CalendarStatusFontClick(Sender: TObject);
begin
     FontDialog1.Font.Assign(AdrockCalendarEdit22.CalendarStatusFont);
     FontDialog1.Execute;
     AdrockCalendarEdit22.CalendarStatusFont.Assign(fontDialog1.Font);
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
Var
  DateStr : String;
begin
  DateStr := '';
  if (InputQuery('Enter a date', 'Date', DateStr) = TRUE) then
       AdrockCalendarEdit8.Date := StrToDate(DateStr);
end;

procedure TForm1.AdrockCalendarEdit1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (Key = VK_F4) then
    (Sender as TAdrockCalendarEdit).ButtonClick;
{    AdrockCalendarEdit1.ButtonClick;}   
end;

end.
